﻿-- Remove existing indexes from Cache table except the Primary Key
DECLARE @Cmd nvarchar(max)
SELECT @Cmd = (SELECT 'DROP INDEX [' + ix.name + '] ON ' + OBJECT_NAME(ix.id) + '; '
FROM  sysindexes ix
WHERE ix.Name IS NOT null AND OBJECT_NAME(ix.id) = 'Cache' AND rows > 0 AND ix.name NOT LIKE 'PK_%'
for xml path(''))
exec sp_executesql @Cmd

GO

-- Add new indexes if not exists
IF NOT EXISTS ( SELECT * FROM  sysindexes ix WHERE  ix.name = 'WIZ_IX_Cache_Key')
BEGIN
CREATE INDEX [WIZ_IX_Cache_Key] ON [dbo].[Cache] ([Key])
END
IF NOT EXISTS ( SELECT * FROM  sysindexes ix WHERE  ix.name = 'WIZ_IX_Cache_Expire')
BEGIN
CREATE INDEX [WIZ_IX_Cache_Expire] ON [dbo].[Cache] ([Expire]) INCLUDE ([Modul], [Key])
END